Ext.data.JsonP.sol_common_ix_functions_ChangeRightsWrapper({"tagname":"class","name":"sol.common.ix.functions.ChangeRightsWrapper","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.ChangeRights.js","href":"sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"requires":["sol.common.AclUtils","sol.common.JsonUtils","sol.common.ObjectFormatter","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.Utils","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"permissionGroupField","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"cfg-permissionGroupField","meta":{}},{"name":"permissionGroups","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"cfg-permissionGroups","meta":{}},{"name":"processChildrenPermissions","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"cfg-processChildrenPermissions","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"determineMode","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-determineMode","meta":{"private":true}},{"name":"getPermissionConfig","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-getPermissionConfig","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-initialize","meta":{"private":true}},{"name":"performChildrenRun","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-performChildrenRun","meta":{"private":true}},{"name":"performSingleRun","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-performSingleRun","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-process","meta":{}},{"name":"processChild","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-processChild","meta":{"private":true}},{"name":"processChildren","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"method-processChildren","meta":{"private":true}},{"name":"RF_sol_function_ChangeRights","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"static-method-RF_sol_function_ChangeRights","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.ChangeRightsWrapper","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.ChangeRightsWrapper","short_doc":"This is a wrapper class for ChangeRights. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.ChangeRightsWrapper</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'>sol.common.Utils</div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper' target='_blank'>sol.common.ix.functions.ChangeRights.js</a></div></pre><div class='doc-contents'><p>This is a wrapper class for <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.</p>\n\n<p>It supports the following modes:</p>\n\n<ul>\n<li>single element</li>\n<li>children (permission groups)</li>\n</ul>\n\n\n<h1>Single element</h1>\n\n<p>The configuration will be passed to <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.</p>\n\n<h2>Node configuration example:</h2>\n\n<p>See <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.</p>\n\n<h1>Children (permission groups)</h1>\n\n<p>Changes rights on the children (only first level) of an element.</p>\n\n<p>The script will read a permission group (or a list) from an index field of each individual child element.\nIf there is a configuration for that permission group(s), it will adjust the rights of the child element by handing that configuration over to <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.</p>\n\n<h2>Node configuration example:</h2>\n\n<pre><code>{\n  \"processChildrenPermissions\": true,\n  \"permissionGroupField\": \"RIGHT_GROUP\",\n  \"permissionGroups\": [\n    { \"name\": \"aclGroup1\", \"config\": { ... } },\n    { \"name\": \"aclGroup1\", \"config\": { ... } },\n    ...\n  ]\n}\n</code></pre>\n\n<p>For the configuration of the single permission groups see <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.\nThe name is used to determine which set of permissions should be applied on which child.</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-permissionGroupField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-cfg-permissionGroupField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-cfg-permissionGroupField' class='name expandable'>permissionGroupField</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The index field containing the permission group(s) for the child.</p>\n</div><div class='long'><p>The index field containing the permission group(s) for the child.</p>\n</div></div></div><div id='cfg-permissionGroups' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-cfg-permissionGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-cfg-permissionGroups' class='name expandable'>permissionGroups</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>The configurations for the different permission groups. ...</div><div class='long'><p>The configurations for the different permission groups. For configuration of each individual group see <a href=\"#!/api/sol.common.ix.functions.ChangeRights\" rel=\"sol.common.ix.functions.ChangeRights\" class=\"docClass\">ChangeRights</a>.\n<code>objId</code> (and <code>objIds</code>) do not have to be configured, the wrapper will take care of those.</p>\n</div></div></div><div id='cfg-processChildrenPermissions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-cfg-processChildrenPermissions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-cfg-processChildrenPermissions' class='name expandable'>processChildrenPermissions</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-determineMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-determineMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-determineMode' class='name expandable'>determineMode</a>( <span class='pre'></span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determines in which mode the function was executed. ...</div><div class='long'><p>Determines in which mode the function was executed.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPermissionConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-getPermissionConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-getPermissionConfig' class='name expandable'>getPermissionConfig</a>( <span class='pre'>permissionGroup</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Loads the permission config for a specified group. ...</div><div class='long'><p>Loads the permission config for a specified group.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>permissionGroup</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-performChildrenRun' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-performChildrenRun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-performChildrenRun' class='name expandable'>performChildrenRun</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Performs a change rights run on all the children depending on the configured permission group per children. ...</div><div class='long'><p>Performs a change rights run on all the children depending on the configured permission group per children.</p>\n</div></div></div><div id='method-performSingleRun' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-performSingleRun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-performSingleRun' class='name expandable'>performSingleRun</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Performs a standard change rights run. ...</div><div class='long'><p>Performs a standard change rights run.</p>\n</div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Performs the processing. ...</div><div class='long'><p>Performs the processing.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-processChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-processChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-processChild' class='name expandable'>processChild</a>( <span class='pre'>child, execBuckets</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determines the right groups for a child element and adds them to the execution buckets. ...</div><div class='long'><p>Determines the right groups for a child element and adds them to the execution buckets.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>child</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>execBuckets</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processChildren' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-method-processChildren' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-method-processChildren' class='name expandable'>processChildren</a>( <span class='pre'>execBuckets</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Processes all child elements on the first level. ...</div><div class='long'><p>Processes all child elements on the first level.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>execBuckets</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_ChangeRights' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-static-method-RF_sol_function_ChangeRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-static-method-RF_sol_function_ChangeRights' class='name expandable'>RF_sol_function_ChangeRights</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRightsWrapper'>sol.common.ix.functions.ChangeRightsWrapper</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRightsWrapper-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRightsWrapper-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});